# Fabric Integration

Integration of `fabric` has been available from version: 0.2.90+.

Enter `@fabric` or `@append_fabric`, followed by fabric parameters

`@fabric` Execute the given fabric command

`@append_fabric` Append assistant previous response to the given fabric command and execute.

# Requirement

Install `fabric` separately, read https://github.com/danielmiessler/fabric

Set up `fabric` by running `fabric --setup` in terminal.  This step crucial to enable ToolMate AI to retrieve available `fabric` patterns. If you have `fabric` installed without setting it up, you may experience an issue when you start up ToolMate AI.

# How to use `fabric` with other ToolMate AI tools?

Assuming `fabric` is installed and the ToolMate AI tool plugin `fabric` is enabled, you may run something like:

```
@fabric -m gemini-1.5-pro -p write_essay "What is machine learning?"
@append_fabric -m llama3.1:latest -p extract_wisdom
@append_fabric -m mistral-large:123b -p summarize
gemini Explain it to a five-year kid
chatgpt Translate it into Chinese
```

For using multiple tools in a single prompt, read https://github.com/eliranwong/toolmate/blob/main/package/toolmate/docs/Running%20Multiple%20Tools%20in%20One%20Go.md

# Use ToolMate AI Backends to run fabric patterns

Use `@fabric_pattern` or `@append_fabric_pattern`, followed by a fabric pattern, to use the fabric pattern as ToolMate AI chat system message. By doing this, the response is generated by the AI backend configured in ToolMate AI, rather than the backend configured in Fabric.

# Select from Available Fabric Patterns

Enter `@fabric_pattern`, `@append_fabric_pattern`, `@fabric -p` or `@append_fabric -p` followed by a space in ToolMate AI prompt, to get a dropdown list of downloaded fabric patterns.

![fabric_pattern](https://github.com/user-attachments/assets/604f4d51-7573-4209-bd9b-3df408581997)

# CLI Options

To use ToolMate AI assigned model and fabric pattern to resolve a query, run:

> tm --chatpattern [pattern]

To search for a pattern, run:

> tm --searchpatterns [query]

# Difference from Running Fabric Alone

Fabric integration in ToolMate AI brings `fabric` to interact with other AI tools, supported by ToolMate AI. Fabric output is directly integrated into the main ToolMate AI message chain.

In addition, by using tool `@fabric_pattern` in interactive mode or CLI option `tm --chatpattern`, users can run fabric patterns with AI backends supported in ToolMate AI, but not available in Fabric.

# Requirement

Install `fabric` first! Read https://github.com/danielmiessler/fabric

# Fabric Integration Setup

Interactive propmt

> toolmate .fabric

CLI:

> tmsetup -fb

# How does the integration work?

The integration works with the tools `@command` and `@append_command` in ToolMate AI

`@command` Execute the given command

`@append_command` Append assistant previous response to the given command and execute.

In plugin `fabric.py`, two aliases are created:

`@fabric` -> `@command fabric`

`@append_fabric` -> `@append_command fabric`

Version 0.2.91 added config item `fabricPath`.  Users can customise fabric path by editing its value in `config.py`.

Read more about system command integration at system command integration at https://github.com/eliranwong/toolmate/blob/main/package/toolmate/docs/System%20Command%20Integration.md

# Differences between Running Fabric via FreGenius AI and Running Fabric Alone

There are three major differences:

1. ToolMate AI work with both text generation and task execution.  Running fabric alone chains up mainly generated texts. With ToolMate AI, text generated by fabric and work with a wider scope of AI tools. `fabric` weaves text together but `ToolMate AI` chains up both texts and actions.

2. Visual text output

Though you may run fabric alone in terminal, like:

```
fabric -p write_essay "What is machine learning?" | fabric -p extract_wisdom | fabric -p summarize
```
The text output in intermediate steps, with fabric alone, are not visible. You can, however, visualize all text-output by running fabric with ToolMate AI, e.g.:

```
@fabric -m gemini-1.5-pro -p write_essay "What is machine learning?"
@append_fabric -m llama3.1:latest -p extract_wisdom
@append_fabric -m mistral-large:123b -p summarize
```

3. Auto-save and Searchable

Results generated in ToolMate AI are auto-saved and searchable.

4. Pattern Clues

FreenGenius AI integrates all fabric patterns in input suggestions, so that users can select a pattern easily.  Take a look at the screenshot above.